<?php
if (!defined('ABSPATH')) exit;

if ($_POST) {
    update_option('sws_uc_enabled', isset($_POST['sws_uc_enabled']) ? 1 : 0);
    update_option('sws_uc_bg_color', sanitize_text_field($_POST['sws_uc_bg_color'] ?? ''));
    update_option('sws_uc_bg_image', esc_url_raw($_POST['sws_uc_bg_image'] ?? ''));
    update_option('sws_uc_logo', esc_url_raw($_POST['sws_uc_logo'] ?? ''));
    update_option('sws_uc_logo_width', intval($_POST['sws_uc_logo_width'] ?? 150));
    update_option('sws_uc_title', sanitize_text_field($_POST['sws_uc_title'] ?? ''));
    update_option('sws_uc_description', sanitize_textarea_field($_POST['sws_uc_description'] ?? ''));
    update_option('sws_uc_launch_date', sanitize_text_field($_POST['sws_uc_launch_date'] ?? ''));
    update_option('sws_uc_template', sanitize_text_field($_POST['sws_uc_template'] ?? '3'));
    update_option('sws_uc_countdown_style', sanitize_text_field($_POST['sws_uc_countdown_style'] ?? 'flip'));
    update_option('sws_uc_font_color', sanitize_hex_color($_POST['sws_uc_font_color'] ?? '#ffffff'));
    update_option('sws_uc_title_size', intval($_POST['sws_uc_title_size'] ?? 40));
    update_option('sws_uc_desc_size', intval($_POST['sws_uc_desc_size'] ?? 18));
    update_option('sws_uc_google_title_font', sanitize_text_field($_POST['sws_uc_google_title_font'] ?? 'Poppins'));
    update_option('sws_uc_google_body_font', sanitize_text_field($_POST['sws_uc_google_body_font'] ?? 'Montserrat'));
}

// fonts list
$fonts = array('Poppins','Montserrat','Roboto','Open Sans','Lato','Playfair Display','Oswald','DM Sans');
?>
<div class="sws-admin-wrapper">
  <h1>SaraS Under Construction — Settings</h1>
  <p class="sws-subtitle">Under Construction settings for your website.</p>

  <form method="POST" action="options.php">
    <?php settings_fields('sws_uc_settings_group'); ?>

    <div class="sws-card">
      <h2>General</h2>
      <label class="sws-label">Enable Under Construction</label>
      <label class="sws-switch">
        <input type="checkbox" name="sws_uc_enabled" value="1" <?php checked(1,get_option('sws_uc_enabled')); ?>>
        <span class="sws-slider"></span>
      </label>

      <label class="sws-label">Background Color</label>
      <input type="color" name="sws_uc_bg_color" value="<?php echo esc_attr(get_option('sws_uc_bg_color','#111111')); ?>" class="sws-input">

      <label class="sws-label">Background Image (optional)</label>
      <div class="sws-upload-box">
        <input type="text" id="sws-bg-url" name="sws_uc_bg_image" value="<?php echo esc_attr(get_option('sws_uc_bg_image')); ?>" class="sws-input">
        <button type="button" class="button sws-upload-btn" data-target="sws-bg-url">Upload</button>
        <button type="button" class="button sws-remove-btn" data-target="sws-bg-url">Remove</button>
      </div>
    </div>

    <div class="sws-card">
      <h2>Branding & Text</h2>

      <label class="sws-label">Logo</label>
      <div class="sws-upload-box">
        <input type="text" id="sws-logo-url" name="sws_uc_logo" value="<?php echo esc_attr(get_option('sws_uc_logo')); ?>" class="sws-input">
        <button type="button" class="button sws-upload-btn" data-target="sws-logo-url">Upload</button>
      </div>

      <label class="sws-label">Logo Width (px)</label>
      <input type="range" name="sws_uc_logo_width" min="50" max="400" value="<?php echo intval(get_option('sws_uc_logo_width',150)); ?>" id="sws-logo-width" class="sws-range">
      <div id="sws-logo-width-val"><?php echo intval(get_option('sws_uc_logo_width',150)); ?>px</div>

      <label class="sws-label">Title</label>
      <input type="text" name="sws_uc_title" value="<?php echo esc_attr(get_option('sws_uc_title','Site Coming Soon')); ?>" class="sws-input">

      <label class="sws-label">Description</label>
      <textarea name="sws_uc_description" class="sws-textarea"><?php echo esc_textarea(get_option('sws_uc_description','We are launching soon.')); ?></textarea>

      <label class="sws-label">Launch Date</label>
      <input type="datetime-local" name="sws_uc_launch_date" value="<?php echo esc_attr(get_option('sws_uc_launch_date')); ?>" class="sws-input">

      <label class="sws-label">Font Color</label>
      <input type="color" name="sws_uc_font_color" value="<?php echo esc_attr(get_option('sws_uc_font_color','#ffffff')); ?>" class="sws-input">

      <label class="sws-label">Title Font Size (px)</label>
      <input type="number" name="sws_uc_title_size" value="<?php echo esc_attr(get_option('sws_uc_title_size',40)); ?>" class="sws-input">

      <label class="sws-label">Description Font Size (px)</label>
      <input type="number" name="sws_uc_desc_size" value="<?php echo esc_attr(get_option('sws_uc_desc_size',18)); ?>" class="sws-input">
    </div>

    <div class="sws-card">
      <h2>Display Options</h2>
      <label class="sws-label">Countdown Style</label>
      <select name="sws_uc_countdown_style" class="sws-input">
        <option value="flip" <?php selected(get_option('sws_uc_countdown_style'),'flip'); ?>>Flip Clock (default)</option>
        <option value="box" <?php selected(get_option('sws_uc_countdown_style'),'box'); ?>>Bold Box</option>
        <option value="line" <?php selected(get_option('sws_uc_countdown_style'),'line'); ?>>Minimal Line</option>
        <option value="neon" <?php selected(get_option('sws_uc_countdown_style'),'neon'); ?>>Neon Glow</option>
      </select>

      <label class="sws-label">Title Google Font</label>
      <select name="sws_uc_google_title_font" class="sws-input">
        <?php foreach($fonts as $f): ?>
          <option value="<?php echo esc_attr($f); ?>" <?php selected(get_option('sws_uc_google_title_font'), $f); ?>><?php echo esc_html($f); ?></option>
        <?php endforeach; ?>
      </select>

      <label class="sws-label">Body / Countdown Google Font</label>
      <select name="sws_uc_google_body_font" class="sws-input">
        <?php foreach($fonts as $f): ?>
          <option value="<?php echo esc_attr($f); ?>" <?php selected(get_option('sws_uc_google_body_font'), $f); ?>><?php echo esc_html($f); ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <!-- TEMPLATES + LIVE PREVIEW -->
    <div class="sws-card">
      <h2>Templates & Live Preview</h2>

      <div class="sws-template-grid">
        <label class="sws-template-item">
          <input type="radio" name="sws_uc_template" value="3" <?php checked(get_option('sws_uc_template'),'3'); ?>>
          <img src="<?php echo plugin_dir_url(__FILE__). '../assets/thumb_template3.jpg'; ?>" alt="T3">
          <span>Dark Minimal</span>
        </label>

        <label class="sws-template-item">
          <input type="radio" name="sws_uc_template" value="4" <?php checked(get_option('sws_uc_template'),'4'); ?>>
          <img src="<?php echo plugin_dir_url(__FILE__). '../assets/thumb_template4.jpg'; ?>" alt="T4">
          <span>Animated Gradient</span>
        </label>

        <label class="sws-template-item">
          <input type="radio" name="sws_uc_template" value="5" <?php checked(get_option('sws_uc_template'),'5'); ?>>
          <img src="<?php echo plugin_dir_url(__FILE__). '../assets/thumb_template5.jpg'; ?>" alt="T5">
          <span>Neon Futuristic</span>
        </label>
      </div>

      <p style="margin-top:12px;">Live Preview (updates on change). Note: preview uses saved settings — click <strong>Save Settings</strong> to refresh if needed.</p>
      <div class="sws-preview-wrapper">
        <iframe id="sws-live-preview" src="<?php echo admin_url('admin-ajax.php?action=sws_uc_preview&template='.get_option('sws_uc_template','3')); ?>" style="width:100%;height:560px;border:1px solid #ddd;border-radius:6px"></iframe>
      </div>
    </div>

    <?php submit_button('Save Settings'); ?>

  </form>
</div>
