jQuery(document).ready(function($){
  // Media uploader
  $('.sws-upload-btn').on('click', function(e){
    e.preventDefault();
    var target = $(this).data('target');
    var frame = wp.media({
      title: 'Select or Upload Image',
      button: { text: 'Use this image' },
      multiple: false
    });
    frame.on('select', function(){
      var att = frame.state().get('selection').first().toJSON();
      $('#'+target).val(att.url);
    });
    frame.open();
  });

  // Remove image
  $('.sws-remove-btn').on('click', function(){
    var t = $(this).data('target');
    $('#'+t).val('');
  });

  // Logo width slider show
  $('#sws-logo-width').on('input change', function(){
    $('#sws-logo-width-val').text($(this).val() + 'px');
  });

  // Refresh preview when inputs change
  function reloadPreview(){
    var iframe = $('#sws-live-preview');
    if (!iframe.length) return;
    var current = iframe.attr('src').split('&_t=')[0];
    iframe.attr('src', current + '&_t=' + new Date().getTime());
  }

  // when any input that affects preview changes, reload iframe
  $('.sws-input, .sws-textarea, .sws-upload-btn, .sws-template-item input, input[name="sws_uc_countdown_style"]').on('change input', function(){
    setTimeout(reloadPreview, 600);
  });

  // when Save Settings button clicked, refresh iframe after save
  $('.sws-save-btn, input[type=submit]').on('click', function(){
    setTimeout(reloadPreview, 900);
  });
});
