document.addEventListener("DOMContentLoaded", function(){
  var box = document.getElementById('sws-countdown');
  if(!box) return;

  var launch = new Date(box.getAttribute('data-launch')).getTime();
  var style = box.getAttribute('data-style') || 'flip';

  function pad(n){ return (n<10? '0'+n : n); }

  function render(numbers){
    if(style==='line'){
      box.innerHTML = numbers.days + 'd | ' + numbers.hours + 'h | ' + numbers.minutes + 'm | ' + numbers.seconds + 's';
      return;
    }

    if(style==='box'){
      box.innerHTML = '<div class="sws-countdown-box">'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.days+'</div><div class="sws-count-label">Days</div></div>'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.hours+'</div><div class="sws-count-label">Hours</div></div>'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.minutes+'</div><div class="sws-count-label">Minutes</div></div>'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.seconds+'</div><div class="sws-count-label">Seconds</div></div>'+
        '</div>';
      return;
    }

    if(style==='neon'){
      box.innerHTML = '<div class="sws-countdown-box" style="filter:drop-shadow(0 0 10px rgba(255,0,255,0.25))">'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.days+'</div><div class="sws-count-label">Days</div></div>'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.hours+'</div><div class="sws-count-label">Hours</div></div>'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.minutes+'</div><div class="sws-count-label">Minutes</div></div>'+
        '<div class="sws-count-item"><div class="sws-count-num">'+numbers.seconds+'</div><div class="sws-count-label">Seconds</div></div>'+
        '</div>';
      return;
    }

    // flip style (simple non-animated flip look)
    box.innerHTML = '<div class="flip-clock">'+
      '<div class="flip-card"><div class="flip-inner"><div class="flip-top"><div class="flip-num">'+pad(numbers.days)+'</div></div><div class="flip-bottom"><div class="flip-num">'+pad(numbers.days)+'</div></div></div><div class="sws-count-label">Days</div></div>'+
      '<div class="flip-card"><div class="flip-inner"><div class="flip-top"><div class="flip-num">'+pad(numbers.hours)+'</div></div><div class="flip-bottom"><div class="flip-num">'+pad(numbers.hours)+'</div></div></div><div class="sws-count-label">Hours</div></div>'+
      '<div class="flip-card"><div class="flip-inner"><div class="flip-top"><div class="flip-num">'+pad(numbers.minutes)+'</div></div><div class="flip-bottom"><div class="flip-num">'+pad(numbers.minutes)+'</div></div></div><div class="sws-count-label">Minutes</div></div>'+
      '<div class="flip-card"><div class="flip-inner"><div class="flip-top"><div class="flip-num">'+pad(numbers.seconds)+'</div></div><div class="flip-bottom"><div class="flip-num">'+pad(numbers.seconds)+'</div></div></div><div class="sws-count-label">Seconds</div></div>'+
      '</div>';
  }

  function update(){
    var now = new Date().getTime();
    var diff = launch - now;
    if(diff <=0){ box.innerHTML = '<div class="sws-launched">Launching Soon!</div>'; return; }
    var days = Math.floor(diff/(1000*60*60*24));
    var hours = Math.floor((diff%(1000*60*60*24))/(1000*60*60));
    var minutes = Math.floor((diff%(1000*60*60))/(1000*60));
    var seconds = Math.floor((diff%(1000*60))/1000);
    render({days:days, hours:hours, minutes:minutes, seconds:seconds});
  }

  update();
  setInterval(update,1000);
});
