<?php
$bg = get_option('sws_uc_bg_color','#0b0b0b');
$bg_img = get_option('sws_uc_bg_image','');
$logo = get_option('sws_uc_logo');
$logo_w = intval(get_option('sws_uc_logo_width',150));
$title = get_option('sws_uc_title','Coming Soon');
$desc = get_option('sws_uc_description','We are working on something awesome.');
$launch = get_option('sws_uc_launch_date');
$font_color = get_option('sws_uc_font_color','#ffffff');
$title_size = get_option('sws_uc_title_size',40);
$desc_size = get_option('sws_uc_desc_size',18);
$style = get_option('sws_uc_countdown_style','flip');
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title><?php echo esc_html($title); ?></title>
  <link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) . 'style.css'; ?>">
  <link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) . 'flip.css'; ?>">
  <style>
    :root{--sws-title-font: '<?php echo esc_attr(get_option('sws_uc_google_title_font','Poppins')); ?>',sans-serif;
           --sws-body-font: '<?php echo esc_attr(get_option('sws_uc_google_body_font','Montserrat')); ?>',sans-serif;}
    body{background:<?php echo esc_attr($bg); ?>; color:<?php echo esc_attr($font_color); ?>; <?php if($bg_img): ?>background-image:url('<?php echo esc_url($bg_img); ?>');background-size:cover;background-position:center;<?php endif; ?>; font-family:var(--sws-body-font);}
    .sws-title{font-size:<?php echo intval($title_size); ?>px}
    .sws-desc{font-size:<?php echo intval($desc_size); ?>px}
    .sws-logo img{width:<?php echo intval($logo_w); ?>px;height:auto}
  </style>
</head>
<body>
  <div class="sws-wrap">
    <div class="sws-card">
      <?php if($logo): ?><div class="sws-logo"><img src="<?php echo esc_url($logo); ?>" alt="logo"></div><?php endif; ?>
      <h1 class="sws-title"><?php echo esc_html($title); ?></h1>
      <p class="sws-desc"><?php echo esc_html($desc); ?></p>
      <div id="sws-countdown" data-launch="<?php echo esc_attr($launch); ?>" data-style="<?php echo esc_attr($style); ?>"></div>
    </div>
  </div>
  <script src="<?php echo plugin_dir_url(__FILE__) . 'countdown.js'; ?>"></script>
</body>
</html>
