<?php
$bg = get_option('sws_uc_bg_color','#050006');
$bg_img = get_option('sws_uc_bg_image','');
$logo = get_option('sws_uc_logo');
$logo_w = intval(get_option('sws_uc_logo_width',150));
$title = get_option('sws_uc_title','Launching Soon');
$desc = get_option('sws_uc_description','Prepare for something unique.');
$launch = get_option('sws_uc_launch_date');
$font_color = get_option('sws_uc_font_color','#ffffff');
$title_size = get_option('sws_uc_title_size',44);
$desc_size = get_option('sws_uc_desc_size',18);
$style = get_option('sws_uc_countdown_style','neon');
?>
<!doctype html><html><head>
  <meta charset="utf-8">
  <title><?php echo esc_html($title); ?></title>
  <link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) . 'style.css'; ?>">
  <link rel="stylesheet" href="<?php echo plugin_dir_url(__FILE__) . 'flip.css'; ?>">
  <style>
    :root{--sws-title-font: '<?php echo esc_attr(get_option('sws_uc_google_title_font','Poppins')); ?>',sans-serif;
           --sws-body-font: '<?php echo esc_attr(get_option('sws_uc_google_body_font','Montserrat')); ?>',sans-serif;}
    body{background:radial-gradient(circle at 10% 10%, #04001e, #000); color:<?php echo esc_attr($font_color); ?>}
    .sws-card{background:linear-gradient(180deg, rgba(255,255,255,0.03), rgba(255,255,255,0.01));padding:50px;border-radius:14px;box-shadow:0 10px 50px rgba(0,0,0,0.6)}
    .sws-title{font-size:<?php echo intval($title_size); ?>px; text-shadow:0 4px 28px rgba(255,0,255,0.12)}
    .sws-desc{font-size:<?php echo intval($desc_size); ?>px; opacity:0.9}
    .sws-logo img{width:<?php echo intval($logo_w); ?>px;height:auto;filter:drop-shadow(0 8px 22px rgba(255,0,255,0.08))}
  </style>
</head><body>
  <div class="sws-wrap">
    <div class="sws-card">
      <?php if($logo): ?><div class="sws-logo"><img src="<?php echo esc_url($logo); ?>" alt="logo"></div><?php endif; ?>
      <h1 class="sws-title"><?php echo esc_html($title); ?></h1>
      <p class="sws-desc"><?php echo esc_html($desc); ?></p>
      <div id="sws-countdown" data-launch="<?php echo esc_attr($launch); ?>" data-style="<?php echo esc_attr($style); ?>"></div>
    </div>
  </div>
  <script src="<?php echo plugin_dir_url(__FILE__) . 'countdown.js'; ?>"></script>
</body></html>
