<?php
/*
Plugin Name: SaraS Under Construction
Description: Under Construction plugin with templates, media uploader, countdown timer, Google Fonts, background image, and admin live preview.
Version: 2.5
Author: Sanmugarajapandian P – SaraS Web Solutions
*/

if (!defined('ABSPATH')) exit;

/* ------------------------------------------------------------
   ADMIN ASSETS (CSS + JS)
------------------------------------------------------------ */
function sws_uc_admin_assets($hook) {
    if ($hook === 'toplevel_page_sws-under-construction') {
        wp_enqueue_style('sws-admin-css', plugin_dir_url(__FILE__) . 'admin/admin-style.css');

        wp_enqueue_media(); // WordPress uploader

        wp_enqueue_script(
            'sws-admin-js',
            plugin_dir_url(__FILE__) . 'admin/admin-script.js',
            array('jquery'),
            false,
            true
        );
    }
}
add_action('admin_enqueue_scripts', 'sws_uc_admin_assets');


/* ------------------------------------------------------------
   FRONT-END ASSETS (CSS + JS + Google Fonts)
------------------------------------------------------------ */
function sws_uc_front_assets() {
    if (!get_option('sws_uc_enabled')) return;
    if (is_user_logged_in() && current_user_can('manage_options')) return;

    wp_enqueue_style('sws-style', plugin_dir_url(__FILE__) . 'public/style.css');
    wp_enqueue_style('sws-flip', plugin_dir_url(__FILE__) . 'public/flip.css');

    wp_enqueue_script('sws-countdown', plugin_dir_url(__FILE__) . 'public/countdown.js', array(), false, true);

    // Google Fonts
    $title_font = get_option('sws_uc_google_title_font', 'Poppins');
    $body_font  = get_option('sws_uc_google_body_font', 'Montserrat');

    $families = urlencode("$title_font:wght@400;700|$body_font:wght@300;400;600");
    wp_enqueue_style('sws-google-fonts', "https://fonts.googleapis.com/css2?family={$families}&display=swap");
}
add_action('wp_enqueue_scripts','sws_uc_front_assets');


/* ------------------------------------------------------------
   ADMIN MENU
------------------------------------------------------------ */
add_action('admin_menu', function() {
    add_menu_page(
        'SaraS Under Construction',
        'Under Construction',
        'manage_options',
        'sws-under-construction',
        'sws_uc_admin_page',
        'dashicons-hammer',
        90
    );
});


/* ------------------------------------------------------------
   LOAD ADMIN PAGE
------------------------------------------------------------ */
function sws_uc_admin_page() {
    include plugin_dir_path(__FILE__) . 'admin/admin-page.php';
}


/* ------------------------------------------------------------
   REGISTER SETTINGS
------------------------------------------------------------ */
function sws_uc_register_settings() {

    $settings = array(
        'sws_uc_enabled',
        'sws_uc_bg_color',
        'sws_uc_bg_image',
        'sws_uc_logo',
        'sws_uc_logo_width',
        'sws_uc_title',
        'sws_uc_description',
        'sws_uc_launch_date',
        'sws_uc_template',
        'sws_uc_font_color',
        'sws_uc_title_size',
        'sws_uc_desc_size',
        'sws_uc_google_title_font',
        'sws_uc_google_body_font',
        'sws_uc_countdown_style'
    );

    foreach ($settings as $s) {
        register_setting('sws_uc_settings_group', $s);
    }
}
add_action('admin_init','sws_uc_register_settings');


/* ------------------------------------------------------------
   FRONT-END OVERRIDE (SHOW UNDER CONSTRUCTION PAGE)
------------------------------------------------------------ */
function sws_uc_frontend_display() {
    if (!get_option('sws_uc_enabled')) return;
    if (is_user_logged_in() && current_user_can('manage_options')) return;

    $template = get_option('sws_uc_template', '3'); // default template 3

    $file = plugin_dir_path(__FILE__) . "public/template-$template.php";
    if (file_exists($file)) {
        include $file;
        exit;
    }
}
add_action('template_redirect', 'sws_uc_frontend_display');


/* ------------------------------------------------------------
   ADMIN BAR TOGGLE
------------------------------------------------------------ */
function sws_uc_admin_bar($admin_bar) {
    if (!current_user_can('manage_options')) return;

    $enabled = get_option('sws_uc_enabled');

    $admin_bar->add_node(array(
        'id'    => 'sws_uc_toggle',
        'title' => $enabled ? 'Under Construction: ON' : 'Under Construction: OFF',
        'href'  => admin_url('admin.php?page=sws-under-construction'),
    ));
}
add_action('admin_bar_menu', 'sws_uc_admin_bar', 100);


/* ------------------------------------------------------------
   LIVE PREVIEW (ADMIN AJAX)
------------------------------------------------------------ */
add_action('wp_ajax_sws_uc_preview', 'sws_uc_preview');
function sws_uc_preview() {
    if (!current_user_can('manage_options')) wp_die('Unauthorized');

    $template = sanitize_text_field($_GET['template'] ?? '3');
    $file = plugin_dir_path(__FILE__) . "public/template-$template.php";

    if (file_exists($file)) {
        include $file;
    } else {
        echo 'Template not found!';
    }
    exit;
}
